#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_inc_IO16AX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=AX;

arg0++;
AX=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16BP(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=BP;

arg0++;
BP=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16BX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=BX;

arg0++;
BX=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16CX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=CX;

arg0++;
CX=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16DI(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=DI;

arg0++;
DI=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16DX(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=DX;

arg0++;
DX=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16SI(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=SI;

arg0++;
SI=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16SP(int seg,Bit8u* imm)
{
Bit16u arg0;



arg0=SP;

arg0++;
SP=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_word(arg0);

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO16regm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));

arg0++;
BX_READ_16BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAP_16(0,0,arg0,BX_INSTR_INC16);
}

void BX_CPU_C::EXEC_inc_IO32EAX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EAX;

arg0++;
EAX=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32EBP(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EBP;

arg0++;
EBP=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32EBX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EBX;

arg0++;
EBX=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32ECX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ECX;

arg0++;
ECX=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32EDI(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EDI;

arg0++;
EDI=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32EDX(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=EDX;

arg0++;
EDX=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32ESI(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ESI;

arg0++;
ESI=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32ESP(int seg,Bit8u* imm)
{
Bit32u arg0;



arg0=ESP;

arg0++;
ESP=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32dsrm161(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32dsrm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32dsrm322D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32r1rm161D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32r1rm161D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32r2rm162(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32r2rm162D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32r2rm162D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm323(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm323D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32rarm323D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_dword(arg0);

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO32regm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));

arg0++;
BX_READ_32BIT_REG((last&0x7))=arg0;

SET_FLAGS_OSZAP_32(0,0,arg0,BX_INSTR_INC32);
}

void BX_CPU_C::EXEC_inc_IO8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8dsrm161(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8dsrm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8dsrm322D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8r1rm161D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8r1rm161D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8r2rm162(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8r2rm162D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8r2rm162D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm323(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm323D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8rarm323D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

arg0++;
write_RMW_virtual_byte(arg0);

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8reghm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0++;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}

void BX_CPU_C::EXEC_inc_IO8reglm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0++;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

SET_FLAGS_OSZAP_8(0,0,arg0,BX_INSTR_INC8);
}
